implementation module windows;

:: *WinState:==Int;

NULL:==0;

:: LP:==Int;
:: HANDLE:==Int;
:: UINT:==Int;

:: LPCTSTR:==LP;
:: HMODULE:==HANDLE;
:: HINSTANCE:==HANDLE;

GetModuleHandle :: !LPCTSTR !WinState -> (!HMODULE,!WinState);
GetModuleHandle module_name ws = code {
	ccall GetModuleHandleA "p:p:p"
}

:: HICON:==HANDLE;

IDI_APPLICATION:==32512;

LoadIcon :: !HINSTANCE !LPCTSTR !WinState -> (!HICON,!WinState);
LoadIcon h_instance icon_name ws = code {
	ccall LoadIconA "Gpp:p:p"
}

IDC_ARROW:==32512;

:: HCURSOR:==HANDLE;

LoadCursor :: !HINSTANCE !LPCTSTR !WinState -> (!HCURSOR,!WinState);
LoadCursor h_instance cursor_name ws = code {
	ccall LoadCursorA "Gpp:p:p"
}

SM_CXSMICON:==49;
SM_CYSMICON:==50;

GetSystemMetrics :: !Int !WinState -> (!Int,!WinState);
GetSystemMetrics index ws = code {
	ccall GetSystemMetrics "GI:I:p"
}

:: HGDIOBJ:==HANDLE;

WHITE_BRUSH:==0;

GetStockObject :: !Int !WinState -> (!HGDIOBJ,!WinState);
GetStockObject fn_object ws = code {
	ccall GetStockObject "GI:p:p"
}

IMAGE_ICON:==1;

LR_DEFAULTCOLOR:==0x0000;

LoadImage :: !HINSTANCE !LPCTSTR !UINT !Int !Int !UINT !WinState -> (!HANDLE,!WinState);
LoadImage h_inst name type cx_desired cy_desired load ws = code {
	ccall LoadImageA "GppIIII:p:p"
}

:: ATOM:==Int;

:: WNDCLASSEX_S:=={#Int};

RegisterClassEx :: !WNDCLASSEX_S !WinState -> (!ATOM,!WinState);
RegisterClassEx wcx ws = code {
	ccall RegisterClassExA "GA:I:p"
}

CS_VREDRAW:==0x0001;
CS_HREDRAW:==0x0002;

string_constant_to_pointer :: !String -> Int;
string_constant_to_pointer s = code {
	push_a_b 0
	pop_a 1
	pushI 16
	addI
}

:: HWND:==HANDLE;
:: LRESULT:==Int;
:: WPARAM:==Int;
:: LPARAM:==Int;

WS_OVERLAPPED :==0x00000000;
WS_CAPTION    :==0x00C00000; /* WS_BORDER | WS_DLGFRAME */
WS_SYSMENU    :==0x00080000;
WS_THICKFRAME :==0x00040000;
WS_MINIMIZEBOX:==0x00020000;
WS_MAXIMIZEBOX:==0x00010000;

WS_OVERLAPPEDWINDOW:==0x00CF0000;
	/* (WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX) */

:: LPCTSTR_S:==String;
:: DWORD:==Int;
:: LPVOID:==LP;
:: HMENU:==HANDLE;

CreateWindowEx :: !DWORD !LPCTSTR_S !LPCTSTR_S !DWORD !Int !Int !Int !Int !HWND !HMENU !HINSTANCE !LPVOID !WinState -> (!HWND,!WinState);
CreateWindowEx ex_style class_name window_name style x y width height parent menu h_instance param ws = code {
	ccall CreateWindowExA "GIssIIIIIpppp:p:p"
|G
}

DefWindowProc :: !HWND !UINT !WPARAM !LPARAM !WinState -> (!LRESULT,!WinState);
DefWindowProc hwnd msg wParam lParam ws = code {
	ccall DefWindowProcA "GpIII:I:p"
}

DefWindowProc_NoWinState :: !HWND !UINT !WPARAM !LPARAM -> LRESULT;
DefWindowProc_NoWinState hwnd msg wParam lParam = code {
	ccall DefWindowProcA "GpIII:I"
}

::BOOL:==Int;

SW_SHOWNORMAL:==1;

ShowWindow :: !HWND !Int !WinState -> (!BOOL,!WinState);
ShowWindow hWnd cmdShow ws = code {
	ccall ShowWindow "GpI:I:p"
|G
}

UpdateWindow :: !HWND !WinState -> (!BOOL,!WinState);
UpdateWindow hWnd ws = code {
	ccall UpdateWindow "Gp:I:p"
|G
}

GetTopWindow :: !HWND !WinState -> (!HWND,!WinState);
GetTopWindow wnd ws= code {
	ccall GetTopWindow "Gp:p:p"
}

WM_CREATE:==0x0001;
WM_DESTROY:==0x0002;
WM_SIZE:==0x0005;
WM_PAINT:==0x000F;

::LPMSG_S:==String;

GetMessage :: !LPMSG_S !HWND !UINT !UINT !WinState -> (!BOOL,!WinState);
GetMessage msg hWnd msgFilterMin msgFilterMax ws = code {
	ccall GetMessageA "GspII:I:p"
}

TranslateMessage :: !LPMSG_S !WinState -> (!BOOL,!WinState);
TranslateMessage msg ws = code {
	ccall TranslateMessage "Gs:I:p"
}

DispatchMessage :: !LPMSG_S !WinState -> (!LRESULT,!WinState);
DispatchMessage msg ws = code {
	ccall DispatchMessageA "Gs:I:p"
|G
}

:: LPRECT_S:==String;
:: LPRECT:==Int;

GetUpdateRect :: !HWND !LPRECT !BOOL !WinState -> (!BOOL,!WinState);
GetUpdateRect hWnd rect erase ws = code {
	ccall GetUpdateRect "GppI:I:p"
}

:: LPPAINTSTRUCT_S:==String;
:: HDC:==HANDLE;

BeginPaint :: !HWND !LPPAINTSTRUCT_S !WinState -> (!HDC,!WinState);
BeginPaint hwnd paint ws = code {
	ccall BeginPaint "Gps:p:p"
}

EndPaint :: !HWND !LPPAINTSTRUCT_S !WinState -> (!BOOL,!WinState);
EndPaint hWnd paint ws = code {
	ccall EndPaint "Gps:I:p"
}

::COLORREF:==Int;

SetPixelV :: !HDC !Int !Int !COLORREF !WinState -> (!BOOL,!WinState);
SetPixelV hdc x y color ws = code {
	ccall SetPixelV "GpIII:I:p"
}

GetProcessHeap :: !WinState -> (!HANDLE,!WinState);
GetProcessHeap ws = code {
	ccall GetProcessHeap ":p:p"
}

:: SIZE_T:==Int;

HeapAlloc :: !HANDLE !DWORD !SIZE_T !WinState -> (!LPVOID,!WinState);
HeapAlloc heap flags bytes ws = code {
	ccall HeapAlloc "pIp:p:p"
}

HeapFree :: !HANDLE !DWORD !LPVOID !WinState -> (!BOOL,!WinState);
HeapFree heap flags mem ws = code {
	ccall HeapFree "pIp:I:p"
}

:: LONG_PTR:==Int;

SetWindowLongPtr :: !HWND !Int !LONG_PTR !WinState -> (!LONG_PTR,!WinState);
SetWindowLongPtr hWnd index newLong ws = code {
	ccall SetWindowLongPtrA "GpIp:p:p"
}

GetWindowLongPtr :: !HWND !Int !WinState -> (!LONG_PTR,!WinState);
GetWindowLongPtr hWnd index ws = code {
	ccall GetWindowLongPtrA "GpI:p:p"
}

PostQuitMessage :: !Int !WinState -> WinState;
PostQuitMessage exitCode ws = code {
	ccall PostQuitMessage "I:V:p"
}

:: LPSECURITY_ATTRIBUTES:==Int;
:: LPTHREAD_START_ROUTINE:==Int;

CreateThread :: !LPSECURITY_ATTRIBUTES !SIZE_T !LPTHREAD_START_ROUTINE !LPVOID !DWORD !WinState -> (!HANDLE,!DWORD,!WinState);
CreateThread threadAttributes stackSize startAddress parameter creationFlags ws = code {
	ccall CreateThread "ppppI:pI:p"
}

INFINITE:==0xFFFFFFFF;

WaitForSingleObject :: !HANDLE !DWORD !WinState -> (!DWORD,!WinState);
WaitForSingleObject handle milliseconds ws = code {
	ccall WaitForSingleObject "pI:I:p"
}

CloseHandle :: !HANDLE !WinState -> WinState;
CloseHandle object ws = code {
	ccall CloseHandle "p:V:p"
}

:: LPCRITICAL_SECTION:==LP;

InitializeCriticalSection :: !LPCRITICAL_SECTION !WinState -> WinState;
InitializeCriticalSection criticalSection ws = code {
	ccall InitializeCriticalSection "p:V:p"
};

EnterCriticalSection :: !LPCRITICAL_SECTION !WinState -> WinState;
EnterCriticalSection criticalSection ws = code {
	ccall EnterCriticalSection "p:V:p"
}

LeaveCriticalSection :: !LPCRITICAL_SECTION !WinState -> WinState;
LeaveCriticalSection criticalSection ws = code {
	ccall LeaveCriticalSection "p:V:p"
}

CreateEvent :: !LPSECURITY_ATTRIBUTES !Int !Int !LPCTSTR !WinState -> (!HANDLE,!WinState);
CreateEvent event_attributes_p manual_reset initial_state name_p ws = code {
	ccall CreateEventA "pIIp:p:p"
}

SetEvent :: !HANDLE !WinState -> (!BOOL,!WinState);
SetEvent event_p ws = code {
	ccall SetEvent "p:I:p"
}

ResetEvent :: !HANDLE !WinState -> (!BOOL,!WinState);
ResetEvent event_p ws = code {
	ccall ResetEvent "p:I:p"
}

GetLastError :: !WinState -> (!DWORD,!WinState);
GetLastError ws = code {
	ccall GetLastError ":I:I"
}

SetDIBitsToDevice :: !HDC !Int !Int !DWORD !DWORD !Int !Int !UINT !UINT !{#Int} !{#Int} !UINT !WinState -> (!Int,!WinState);
SetDIBitsToDevice hdc xDest yDest dwWidth dwHeight xSrc ySrc uStartScan cScanLines lpvBits lpbmi fuColorUse ws = code {
	ccall SetDIBitsToDevice "pIIIIIIIIAAI:I:I"
}
